#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int idx;
    long long w, v;
    double ratio;
} Ponco;

int cmp(const void *a, const void *b) {
    Ponco *p1 = (Ponco*)a;
    Ponco *p2 = (Ponco*)b;
    if(p2->ratio > p1->ratio) return 1;
    else if(p2->ratio < p1->ratio) return -1;
    else return 0;
}

int main() {
    int N;
    long long W;
    double eps;
    scanf("%d %lld %lf", &N, &W, &eps);

    Ponco p[N];
    for(int i=0;i<N;i++){
        scanf("%lld %lld",&p[i].w,&p[i].v);
        p[i].idx = i+1;
        p[i].ratio = (double)p[i].v / p[i].w;
    }


    qsort(p, N, sizeof(Ponco), cmp);

    long long totalW = 0;
    long long totalV = 0;
    int selected[N];
    int k = 0;

    for(int i=0;i<N;i++){
        if(totalW + p[i].w <= W){
            totalW += p[i].w;
            totalV += p[i].v;
            selected[k++] = p[i].idx;
        }
    }

    printf("%d\n", k);
    for(int i=0;i<k;i++){
        printf("%d%c", selected[i], i==k-1?'\n':' ');
    }

    return 0;
}